package gov.va.med.mhv.mrp.data.repository;

import gov.va.med.mhv.mrp.data.model.MyGoalsTasks;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly = true)
public interface MyGoalTaskRepository extends JpaRepository<MyGoalsTasks, Long> {
	
	@Query ("select task from MyGoalsTasks task, MyGoalsExtensions ext, MyGoals g  "+
            "where  task.myGoalsExtension.goalExtensionId = ext.goalExtensionId and ext.myGoal.goalId = g.goalId "+
			"and ext.myGoal.status = 1 and g.userProfileId = :userProfileId " ) 
	public List<MyGoalsTasks> getMyGoalTasksForUser(@Param("userProfileId") Long userProfileId);

	
	@Query ("select task from MyGoalsTasks task, MyGoalsExtensions ext, MyGoals g  "+
            "where  task.myGoalsExtension.goalExtensionId = ext.goalExtensionId and ext.myGoal.goalId = g.goalId "+
			"and ext.myGoal.status = 1 and g.userProfileId = :userProfileId " + 
			"and (UPPER(task.taskName) like :keyword or UPPER(task.description) like :keyword or UPPER(g.goalName) like :keyword  )")
	public List<MyGoalsTasks> getMyGoalTasksBykeyword(@Param("userProfileId") Long userProfileId, @Param("keyword") String keyword);
	
	
	@Query ("select task from MyGoalsTasks task, MyGoalsExtensions ext, MyGoals g  "+
            "where  task.myGoalsExtension.goalExtensionId = ext.goalExtensionId and ext.myGoal.goalId = g.goalId "+
			"and g.userProfileId = :userProfileId " +
			"and g.goalName = :goalName " + 
			"and task.taskName = :taskName ")
	public List<MyGoalsTasks> getMyGoalTasksForName(@Param("userProfileId") Long userProfileId, @Param("taskName") String taskName, @Param("goalName") String goalName);
}
